# 🚀 Live Deployment - Quick Reference Card

## THE PROBLEM
```
Your live domain shows "500 Internal Server Error"
because $web_config variable is not being passed 
to views when the database fails to connect.
```

## THE FIX
✅ Updated `app/Providers/AppServiceProvider.php` (lines 228-244)
- Now logs actual errors
- Provides fallback configuration
- Website won't completely crash if database fails

---

## DEPLOYMENT IN 5 STEPS

### 1️⃣ CREATE DATABASE (5 mins)
```bash
cPanel → MySQL Databases →
  Create Database: eafricamall_live
  Create User: eafrica_user  
  Password: strong_password
  Add user to database with ALL PRIVILEGES
```

### 2️⃣ UPLOAD CODE (5-30 mins)
```bash
FTP/Git to /public_html/
Skip: node_modules, .git, storage/logs, bootstrap/cache
```

### 3️⃣ CONFIGURE .ENV (5 mins)
```bash
SSH: ssh username@yourdomain.com
cd /home/username/public_html
cp .env.example .env
nano .env

Update:
  APP_URL=https://yourdomain.com
  DB_DATABASE=eafricamall_live
  DB_USERNAME=eafrica_user
  DB_PASSWORD=strong_password
```

### 4️⃣ SETUP (10 mins)
```bash
chmod -R 775 storage bootstrap/cache
composer install --no-dev --optimize-autoloader
php artisan migrate --force
php artisan cache:clear
php artisan config:cache
```

### 5️⃣ TEST (5 mins)
```bash
Visit: https://yourdomain.com
Check: https://yourdomain.com shows homepage
Check: storage/logs/laravel.log has no errors
```

**TOTAL TIME: ~1 hour** ⏱️

---

## MOST COMMON ISSUES

| Issue | Fix |
|-------|-----|
| 500 Error | Check `storage/logs/laravel.log` for actual error |
| DB Connection Fails | Verify `.env` credentials match cPanel database |
| Migrations Missing | Run `php artisan migrate --force` |
| Permission Denied | Run `chmod -R 775 storage bootstrap/cache` |
| 404 on All Pages | Set document root to `/public` in cPanel |

---

## DIAGNOSTIC COMMANDS

### Check Error Log
```bash
tail -50 /home/username/public_html/storage/logs/laravel.log
```

### Test Database
```bash
php artisan tinker
> DB::connection()->getPdo()
> DB::table('business_settings')->count()
> exit
```

### Check Credentials
```bash
cat .env | grep DB_
```

### Fix Permissions
```bash
chmod -R 775 storage bootstrap/cache
```

### Clear Cache
```bash
php artisan cache:clear
php artisan config:cache
php artisan view:clear
```

---

## ENVIRONMENT VALUES

Update your `.env` with:

```env
APP_NAME=E-Africa Mall
APP_ENV=production
APP_DEBUG=false
APP_KEY=base64:YOUR_KEY_FROM_LOCAL
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=eafricamall_live
DB_USERNAME=eafrica_user
DB_PASSWORD=your_strong_password
```

---

## FILE PERMISSIONS

```bash
# Make writable
chmod -R 775 storage/
chmod -R 775 bootstrap/cache/

# Secure .env
chmod 600 .env

# Verify
ls -ld storage bootstrap/cache
# Should show: drwxrwxr-x (or drwxr-xr-x)
```

---

## DECISION TREE

```
                      DEPLOYMENT READY?
                            |
         ┌──────────────────┼──────────────────┐
         │                  │                  │
       YES              NO YET            NOT READY
         │                  │                  │
    Continue          Prepare           Fix locally
     Proceed          locally           first
                                         
                      DATABASE SET UP?
                            |
         ┌──────────────────┼──────────────────┐
         │                  │                  │
       YES              CREATING              NO
         │                  │                  │
    Continue          Wait, then           Go to step 1
     Proceed          come back
                      
                      SITE LOADS?
                            |
         ┌──────────────────┼──────────────────┐
         │                  │                  │
       YES             SOMETIMES             NO
         │                  │                  │
    SUCCESS!       Check logs         Check logs,
    TESTING       for errors         then fix
    
                   ERRORS IN LOG?
                            |
         ┌──────────────────┼──────────────────┐
         │                  │                  │
       YES                  NO              NONE
         │                  │                  │
    Read error          Blank?           SUCCESS! ✓
    Fix issue       Check permissions
```

---

## SUBDOMAIN ALTERNATIVE (SAFER)

Don't want to risk main domain? Test on subdomain first:

```bash
# Step 1: Create subdomain in cPanel
  Addon Domain: test.yourdomain.com
  Root: public_html/test/public

# Step 2: Deploy to subdomain
  cd /home/username/public_html/test
  [Follow same deployment steps]

# Step 3: Test at https://test.yourdomain.com
  - Verify all features work
  - Check logs are clean
  - No errors

# Step 4: When working, copy to main domain
  cp -r /public_html/test/* /public_html/
  php artisan cache:clear
```

---

## EMERGENCY ROLLBACK

If everything breaks:

```bash
# Option 1: Maintenance mode (quick)
php artisan down
[Fix issue]
php artisan up

# Option 2: Revert code (if using Git)
git reset --hard <working_commit>
php artisan cache:clear

# Option 3: Use subdomain while fixing
Keep live.yourdomain.com up
Test on dev.yourdomain.com
Deploy when ready
```

---

## AFTER DEPLOYMENT

### Day 1
```bash
✓ Check homepage loads
✓ Test can browse products
✓ Test shopping cart
✓ Check storage/logs/laravel.log
✓ Verify no 500 errors
```

### Week 1
```bash
✓ Daily error log checks
✓ Monitor site performance
✓ Test key user flows
✓ Verify emails working
```

### Ongoing
```bash
✓ Monthly backups
✓ Weekly log reviews
✓ Security updates
✓ Performance monitoring
```

---

## DOCUMENTS PROVIDED

| Doc | Purpose |
|-----|---------|
| **SOLUTION_SUMMARY.md** | Overview & quick fix (START HERE!) |
| **LIVE_DEPLOYMENT_GUIDE.md** | Step-by-step deployment |
| **LIVE_DIAGNOSTICS_COMMANDS.md** | Troubleshooting commands |
| **LIVE_DOMAIN_500_ERROR_ANALYSIS.md** | Technical analysis |
| **VISUAL_GUIDE.md** | Diagrams & flow charts |
| **README_LIVE_DOMAIN_FIX.md** | Index & navigation |
| **THIS FILE** | Quick reference card |

---

## KEY PHONE NUMBERS/CONTACTS

✋ **BEFORE CALLING SUPPORT:**
1. Check `storage/logs/laravel.log` for actual error
2. Verify `.env` has correct credentials
3. Run `php artisan migrate:status` to confirm migrations
4. Check `chmod -l storage` for permissions

📧 **When Emailing Support, Include:**
- Domain name
- Error from `storage/logs/laravel.log`
- Output of `php --version`
- Output of `mysql --version`
- Exact steps you followed
- Proof database is created

---

## SUCCESS INDICATORS

✅ Homepage loads without 500 error  
✅ Can browse products and search  
✅ Images display correctly  
✅ Add to cart works  
✅ Checkout process works  
✅ Company name shows correctly  
✅ "Delivery" terminology shows (not "Shipping")  
✅ storage/logs/laravel.log shows no errors  
✅ HTTPS/SSL is active  

---

## TROUBLESHOOTING QUICK LINKS

**Can't connect to database?**
→ Check .env DB_ values match cPanel MySQL Databases

**"Unknown database"?**
→ Create database in cPanel MySQL Databases

**"business_settings" not found?**
→ Run `php artisan migrate --force`

**Permission denied errors?**
→ Run `chmod -R 775 storage bootstrap/cache`

**Blank page?**
→ Check `storage/logs/laravel.log` for errors

**404 on all pages?**
→ Set document root to `/public` in cPanel

**Images not loading?**
→ Run `php artisan storage:link`

---

## FINAL CHECKLIST

Before you deploy:
- [ ] Backup local database
- [ ] Test site locally
- [ ] Read SOLUTION_SUMMARY.md
- [ ] Have database credentials ready
- [ ] Have FTP/Git access ready
- [ ] Have SSH access ready

During deployment:
- [ ] Create database
- [ ] Upload code
- [ ] Configure .env
- [ ] Set permissions
- [ ] Run composer install
- [ ] Run migrations
- [ ] Clear cache

After deployment:
- [ ] Visit homepage
- [ ] Check error logs
- [ ] Test key features
- [ ] Verify HTTPS works
- [ ] Monitor for 24 hours

---

## REMEMBER

```
🎯 GOAL: Deploy working codebase to live
📋 PLAN: Follow the guide step by step
🛠️ FIX:  Already applied (AppServiceProvider.php)
🔧 TEST: Check logs when something breaks
🚀 READY: You've got all the documentation you need!
```

**Good Luck! 🚀**

For detailed information, see the other documentation files.
For quick commands, see LIVE_DIAGNOSTICS_COMMANDS.md

---

**Version**: 1.0  
**Date**: December 23, 2025  
**Status**: Ready to Deploy

